#! /usr/bin/python
# -*- coding: utf-8 -*-

from blindstation import *
import blindstation.game
from blindstation.utils import BSError

from random import choice
from os.path import exists
from os import remove, mkdir
from shutil import copy
from string import rstrip,split
from time import strftime

from myBStools import myMenu,sayNumbersClass
from version import versionNb, devMode
from foldername import *
from msmain import MainSc
from msHelp import helpTree

import mLevels
import sys
import codecs



# -- ----------------------------------------------------------------

SCORE_FILE=LOCAL_FOLDER+'SCORES'
USERS_FILE=LOCAL_FOLDER+'USERS'
RESCUE_FILE=LOCAL_FOLDER+'RESCUE'



# -- ----------------------------------------------------------------
#    Intro
# -- ----------------------------------------------------------------

class Intro (myMenu):
  
  def __init__ (self, parent, gameInfo):
    
    myMenu.__init__(self, parent, 'intro', 'logo')
    
    if not exists(LOCAL_FOLDER):
      mkdir(LOCAL_FOLDER)
      
    self.BSplash = Widget(self, 'splash_button', 'init')
    self.BSplash.validate_callback = self.continueIntro
    
    self.gameInfo = gameInfo
    self.when = 0

    self.teamTmx = Timer (self,"_Tmx.team")
    self.teamTmx.timer_callback = self.continueIntro
    self.teamTmx.setTime(3000)

    self.sndSourceMessages = Source(self, 'Messages')
    
    self.exit = Widget(self, '_Exit', 'std')
    self.exit.hidden = True
    self.exit.validate_callback = self.exit_callback


  def exit_callback (self, name, type, key):
    self.next = None


  def continueIntro (self, name, type=None, key=None):

    if self.when == 0:
      
      self.teamTmx.setTime(0)
      self.state = 'splash'
      self.BSplash.state = 'splash'
      
      self.sndSourceMessages.empty()
      self.sndSourceMessages.queue('intro-mus')
      self.sndSourceMessages.source_callback = self.continueIntro
      self.sndSourceMessages.play()

      self.when = 1
      
    elif self.when == 1:

      self.sndSourceMessages.empty()
      self.sndSourceMessages.queue('intro')
      self.sndSourceMessages.source_callback = self.continueIntro
      self.sndSourceMessages.play()

      self.when = 2

    elif self.when == 2:

      self.sndSourceMessages.stop()

      self.next = MenuSc
      self.nextargs = [self.gameInfo]



# -- ----------------------------------------------------------------
#    Credits
# -- ----------------------------------------------------------------

class CreditsSc (Scene):
  
  def __init__ (self, parent, gameInfo):
    
    Scene.__init__(self, parent, 'credits', 'logo')
    self.gameInfo = gameInfo

    self.creditTmx = Timer (self,"_Tmx.credits")
    self.creditTmx.timer_callback = self.credits
    self.creditTmx.setTime(5000)

    self.exit = Widget (self, '_Exit', 'std')
    self.exit.hidden = True
    self.exit.validate_callback = self.credits

    self.titleWidget = Widget (self, 'url', 'std')

    
  def credits (self, name, type=None, key=None):
    self.next = None



# -- ----------------------------------------------------------------
#    Menus
# -- ----------------------------------------------------------------

class MenuSc (myMenu):
  
  def __init__ (self, parent, gameInfo):
    myMenu.__init__(self, parent, 'menu', 'init')

    self.gameInfo = gameInfo
    self.gameInfo.setDefaultValues()
    
    self.BTitle = Widget(self, '_Title', 'std')
    self.BVersion = Widget(self, '_Version', 'std')
    self.BVersion.text = "Version "+versionNb

    self.addMenuItem('MN_NewGame', 'init', "Yes", voiceFile='MN_NewGame')
    self.addMenuItem('MN_LoadGame', 'init', "Yes", voiceFile='MN_LoadGame')
    self.addMenuItem('MN_HighScores', 'init', "Yes", voiceFile='MN_HighScores')
    self.addMenuItem('MN_Help', 'init', "Yes", voiceFile='MN_Help')
    self.addMenuItem('MN_Quit', 'init', "Yes", 'menuquit', voiceFile='MN_Quit')

    self.zoom_widget = Widget(self, 'zoom', 'init')
    self.zoom_widget.hidden = True
    self.zoom_widget.validate_callback = self.zoom_callback
    
    self.setTickSound('menutick')
    self.setLaunchSound('menuconfirm')
    self.setTopBottomSounds('menutopdown')

    self.sndSourceMessages.empty()
    self.sndSourceMessages.queue('MainMenu')
    self.sndSourceMessages.source_callback = self.cbVoiceTitle
    self.sndSourceMessages.play()


  def launchCallback (self, name):
    name = self.selectedItem
    if name == 'MN_NewGame':
      self.startGame(name,None,None)
    elif name == 'MN_LoadGame':
      self.loadGames(name,None,None)
    elif name == 'MN_HighScores':
      self.dispHighScores(name,None,None)
    elif name == 'MN_Help':
      self.helpGames(name,None,None)
    elif name == 'MN_Quit':
      self.exit_callback(name,None,None)

      
  def cbVoiceTitle (self, name):
    self.sndSourceMessages.stop()
    self.sndSourceMessages.source_callback = None
    self.set_focus(self.findFocusIndex(self.Order[0]))

  #-- --------------------------------------------------

  def startGame (self, name, type, key):
    #self.next = MainSc
    self.gameInfo.score = -1
    self.next = SaveLoadSc
    self.nextargs = [self.gameInfo]


  def dispHighScores (self,name, type, key):
    self.next = HighScoreSc
    self.nextargs = [self.gameInfo]

  def helpGames (self,name, type, key):
    self.next = HelpSc
    self.nextargs = [self.gameInfo]


  def loadGames (self,name, type, key):
    self.next = SaveLoadSc
    self.nextargs = [self.gameInfo]


  def exit_callback (self, name, type, key):
    self.next = CreditsSc
    self.nextargs = [self.gameInfo]



# -- ----------------------------------------------------------------
#    Save and Load games
# -- ----------------------------------------------------------------

class SaveLoadSc (myMenu):
  
  def __init__ (self, parent, gameInfo):
    myMenu.__init__(self, parent, 'saveload', 'init')

    self.sayNumbersEngine = sayNumbersClass()

    self.gameInfo = gameInfo
    self.oldGameInfoScore = self.gameInfo.score

    self.caretFlag = 0
    self.umlFlag = 0

    if self.gameInfo.score == 0: # load mode
      self.status = 1
    else:                        # save mode
      self.status = 0 
      if self.gameInfo.score == -1:
        self.gameInfo.score = 0
        
    self.nbUsers = 5
    if exists(USERS_FILE):
      self.users = self.readUsersFile()
    else:
      self.users = self.createUsersFile()

    self.BTitle = Widget(self, '_Title', 'init')
    self.BSubTitle = Widget(self, '_SubTitle', 'init')
    self.BSubTitle.state = 'choice'

    self.setTickSound('menutick')
    self.setLaunchSound('emptyKey')
    self.setTopBottomSounds('menutopdown')      

    self.zoom_widget = Widget(self, 'zoom', 'init')
    self.zoom_widget.hidden = True
    self.zoom_widget.validate_callback = self.zoom_callback

    self.space_widget = Widget(self, 'space', 'init')
    self.space_widget.hidden = True
    self.space_widget.validate_callback = self.space_callback

    self.createUsersCells()

####    self.BVOLPLUS=myButton(self.back,self.Resource('_VolPlus'),'std')
####    self.BVOLPLUS.pyattach(self.__class__.cbIncVolume,self)
####    self.BVOLMOINS=myButton(self.back,self.Resource('_VolMoins'),'std')
####    self.BVOLMOINS.pyattach(self.__class__.cbDecVolume,self)

    self.BEsc = Widget(self, '_Esc', 'init')
    self.BEsc.hidden = True
    self.BEsc.validate_callback = self.cbEsc

    self.WDelete = Widget(self, 'key_BACKSPACE', 'init')
    self.WDelete.hidden = True

    self.WKeys = Widget(self, 'keys', self.lang)
    self.WKeys.hidden = True

    self.sndSourceMessages.empty()
    canplay = 0
    if self.status == 0:
      self.sndSourceMessages.queue('SaveScene')
      canplay = 1
    elif self.status == 1:
      self.sndSourceMessages.queue('LoadScene')
      canplay = 1

    if canplay == 1:
      self.sndSourceMessages.source_callback = self.cbVoiceTitle
      self.sndSourceMessages.play()


  def cbVoiceTitle (self, name):
    self.set_focus(self.findFocusIndex(self.Order[0]))

    
  def createUsersCells (self):
    for i in range(self.nbUsers):
      if self.users[i][0] != "":
        self.addMenuItem('User0'+`i`, 'init', "Yes", sndFile='menuconfirm')
      else:
        if self.status == 1:
          self.addMenuItem('User0'+`i`, 'init', "Yes")
        else:
          self.addMenuItem('User0'+`i`, 'init', "Yes", sndFile='menuconfirm')
      self.menuButton('User0'+`i`).text = "  "+`i+1`+" - "+self.users[i][0]


  def launchCallback (self, name):
    self.cbSelect(self.selectedItem,None,None)


  def space_callback (self, name, type, key):
    if self.status == 3 and self.saisie != '':
      self.sayWord(self.saisie)


  def cbEsc (self, name, type, key):
    self.sndSourceMessages.empty()
    self.sndSourceMessages.queue('menuback')
    if self.status == 1 or self.oldGameInfoScore == -1:
      self.sndSourceMessages.source_callback = self.cbBackToMenu
    elif self.status == 3:
      self.sndSourceMessages.source_callback = self.cbBackToSaveLoadSc
    else:
      self.sndSourceMessages.source_callback = self.cbBackToMenu
    if self.oldGameInfoScore == -1:
      self.oldGameInfoScore = 0
    self.sndSourceMessages.play()  


  def cbBackToMenu (self, name):
    self.next = MenuSc
    self.nextargs = [self.gameInfo]


  def cbBackToSaveLoadSc (self, name):
    self.gameInfo.score = self.oldGameInfoScore
    self.next = SaveLoadSc
    self.nextargs = [self.gameInfo]


  def cbBackToGame (self, name):
    self.gameInfo.score = self.oldGameInfoScore
    self.next = MainSc
    self.nextargs = [self.gameInfo]


  # -- --------------------------------------------------------------

  def getSentenceToSay (self, num):
    phrase = self.sayNumbersEngine.tospeech1e6(num,self.lang)
    if phrase!='overflow': return map(lambda c:c[1],phrase)
    return []


  def addWordToSource (self, word):
    for letter in word:
      self.sndSourceMessages.queue(letter)


  def sayWord (self, word):
    canplay=0

    self.sndSourceMessages.empty()
    self.sndSourceMessages.source_callback=None

    if word != "":
      self.addWordToSource(word)
      canplay=1

    if canplay==1:
      self.sndSourceMessages.play()


  def cbGrabFocusMenu (self, name):
    canplay=0

    self.sndSourceMessages.empty()
    self.sndSourceMessages.source_callback=None

    if self.ticksound!=None:
      self.sndSourceMessages.queue(self.ticksound)
      canplay=1

    num = int(name[-1:])+1
    user = self.users[self.Order.index(name)][0]
    
    phrase = self.getSentenceToSay(num)
    if phrase != []:
      for mot in phrase:
        self.sndSourceMessages.queue(mot)
      canplay=1

    if user != "":
      self.addWordToSource(user)
      canplay=1

    if canplay==1:
      self.sndSourceMessages.play()


  def cbSelect (self, name, type, key):
    file = self.users[self.Order.index(name)][1]
    if self.status == 1:

      if exists(LOCAL_FOLDER+file): # start saved game
        self.gameInfo.loadGame(file)
        self.gameInfo.autoSaveName = self.users[self.Order.index(name)]
        self.next = MainSc
        self.nextargs = [self.gameInfo]

      else:
        self._menustatus = 1
        self.sndSourceMessages.empty()
        self.sndSourceMessages.queue('emptypos')
        self.sndSourceMessages.source_callback = None
        self.sndSourceMessages.play()

    elif self.status == 0: # Save the file info, first ask a name, then go back to the menu
      self.idxSaisie = self.Order.index(name)
      self.set_focus(self.BTitle.__id__)
      self.supprUsersCells()

      self.saisie = self.users[self.idxSaisie][0]

      self.BSubTitle.state = 'input'
      self.BPanneau = Widget(self, 'Panneau', 'init')
      self.BPanneau.text = self.saisie
      self.BPanneau.validate_callback = self.cbValide

      self.WDelete.validate_callback = self.cbDelete
      self.WKeys.validate_callback = self.keysCallback

      self.sndSourceMessages.empty()
      self.sndSourceMessages.queue('inputsavename')
      self.sndSourceMessages.source_callback = self.cbInputReady
      self.sndSourceMessages.play()
      

  def cbInputReady (self,name):
    self.status = 3
    self.set_focus(self.BPanneau.__id__)
    self.sayWord(self.saisie)

  
  def supprUsersCells (self):
    for i in range(self.nbUsers):
      self.removeMenuItem('User0'+`i`)

  # -- --------------------------------------------------------------

  def cbDelete (self, name, type, key):
    if len(self.saisie) > 0:
      self.sndSourceMessages.empty()
      self.sndSourceMessages.queue('deleteKey')
      self.sndSourceMessages.play()
      self.saisie = self.saisie[:len(self.saisie)-1]
      self.BPanneau.text = self.saisie
      self.BPanneau.alt = self.saisie
    else:
      self.sndSourceMessages.empty()
      self.sndSourceMessages.queue('emptyKey')
      self.sndSourceMessages.play()
    return 0


  def encode (self, word):
    return unicode(word,'latin-1')
    

  def keysCallback (self, name, type, key):
    if key == KeyCode.CARET:
      self.caretFlag = 1
      self.umlFlag = 0
      
    elif key == KeyCode.WORLD_8:
      self.caretFlag = 0
      self.umlFlag = 1
      
    else:
      char = chr(key)
      
      if self.caretFlag == 1:
        if char == 'a':
          char = ''
        elif char == 'e':
          char = ''
        elif char == 'i':
          char = ''
        elif char == 'o':
          char = ''
        elif char == 'u':
          char = ''
          
      elif self.umlFlag == 1:
        if char == 'e':
          char = ''
        elif char == 'i':
          char = ''
        elif char == 'u':
          char = ''
            
      self.caretFlag = 0
      self.umlFlag = 0

      letter = self.encode(char)

      self.sndSourceMessages.empty()
      self.sndSourceMessages.queue(letter)
      self.sndSourceMessages.play()

      self.saisie += letter
      self.BPanneau.text = self.saisie
      self.BPanneau.alt = self.saisie


  # -- --------------------------------------------------------------

  def cbValide (self, name, type, key):
    if self.status == 3 and self.saisie != '':
      self.set_focus(self.BTitle.__id__)
      del self.BPanneau
      self.BSubTitle.state = 'choice'
      self.users[self.idxSaisie][0] = self.saisie

      self.status = 1
      self.createUsersCells()
      
      self.saveUsersFile(self.users)
      if self.gameInfo.score == 0:
        self.gameInfo.saveGame(self.users[self.idxSaisie])
      else:
        self.gameInfo.copySaveGame(self.users[self.idxSaisie])

      self._menustatus = 1
      
      self.cbSelect(self.Order[self.idxSaisie],None,None)


  # -- --------------------------------------------------------------

  def createUsersFile (self):
    users = []
    for i in range(self.nbUsers):
      users.append(['','user'+`i+1`])
    self.saveUsersFile(users)
    return users


  def saveUsersFile (self, users):
    # Le caractere '|' doit etre interdit dans les noms de joueurs
    f = open(USERS_FILE,"w")
    f.write("# MudSplat "+versionNb+"\n")
    f.write("# USERS FILE\n")
    f.write("# DO NOT EDIT: GENERATED AUTOMATICALLY\n")

    for u in users:
      f.write(u[0].encode('latin-1'))
      #f.write(u[0])
      f.write('|'+u[1]+'\n')
    f.close()


  def readUsersFile (self):
    users = []
    f = open(USERS_FILE,"r")
    line = f.readline()
    while line:
      if line[0]!='#':
        u=split(line.rstrip(),'|')
        u[0] = self.encode(u[0])
        users.append(u)
      line=f.readline()
    f.close()

    return users



# -- ----------------------------------------------------------------
#    High Scores
# -- ----------------------------------------------------------------

class HighScoresValue:

  def __init__ (self, nvds):
    nvd = split(nvds,':')
    #self.name = nvd[0]
    self.name = self.encode(nvd[0])
    self.value = int(nvd[1])
    self.date = nvd[2]
    self.monsters = int(nvd[3])
    self.levels = int(nvd[4])


  def encode (self, word):
    return unicode(word,'latin-1')

      
  def createString (self):
    return self.name.encode('latin-1')+':'+`self.value`+':'+self.date+':'+`self.monsters`+':'+`self.levels`

  
  def createDisplay (self):
    return self.name+' ('+`self.value`+')'


  def scoreValue (self): return self.value
  def scoreName (self): return self.name
  def monstersValue (self): return self.monsters
  def levelsValue (self): return self.levels

#-- ----------------------------------------------------

class HighScoresListe:

  def __init__ (self, nbscores):
    self.nbscores = nbscores
    self.hsliste = []


  def readHSFile (self, filename):
    cc = 0
    if exists(filename):
      f_in = open(filename,'r')
      line = f_in.readline()
      while cc < self.nbscores and line:
        cc += 1
        self.hsliste.append(HighScoresValue(rstrip(line)))
        line = f_in.readline()
      f_in.close()

      
  def saveHSFile (self, filename):
    f_out = open(filename,'w')
    for item in self.hsliste:
      f_out.write(item.createString()+'\n')
    f_out.close()


  def isInList (self, value):
    return value>0\
           and (len(self.hsliste)<self.nbscores\
                or value>self.hsliste[self.nbscores-1].value)

    
  def insertScore (self, value, name, monsters, levels):
    #to use only if the value is a high score
    if value!=0:
      i=0
      while i < len(self.hsliste) and value <= self.hsliste[i].value:
        i += 1
      if i < 10:
        self.hsliste.insert(i,HighScoresValue(\
          name+':'+`value`+':'+strftime("%y-%m-%d")+':'+`monsters`+':'+`levels`))
    return i



# -- ----------------------------------------------------------------

class HighScoreSc (myMenu):

  def __init__ (self, parent, gameInfo):
    # insert the new score if relevant
    # when called with gameInfo.score=0, only display

    myMenu.__init__(self, parent, 'highscore', 'init')

    self.gameInfo = gameInfo

    self.BTitle = Widget(self, '_TitleHS', 'init')
    
    self.liste = HighScoresListe(10)
    self.liste.readHSFile(SCORE_FILE)

    self.sayNumbersEngine = sayNumbersClass()

    self.zoom_widget = Widget(self, 'zoom', 'init')
    self.zoom_widget.hidden = True
    self.zoom_widget.validate_callback = self.zoom_callback
    
    self.caretFlag = 0
    self.umlFlag = 0

    if self.gameInfo.score != 0 and self.liste.isInList(self.gameInfo.score):
      self.status = 1

      self.BSubTitle = Widget(self, 'InputName', 'init')
      self.BPanneau=Widget(self,'Panneau','init')
      self.BPanneau.validate_callback=self.cbValide

      self.saisie=self.gameInfo.playerName
      self.BPanneau.text=self.saisie

      self.WDelete = Widget(self, 'key_BACKSPACE', 'init')
      self.WDelete.hidden = True
      self.WDelete.validate_callback = self.cbDelete

      self.WKeys = Widget(self, 'keys', self.lang)
      self.WKeys.hidden = True
      self.WKeys.validate_callback = self.keysCallback

      self.sndSourceBgsound = Source(self,'BgSound')
      self.sndSourceBgsound.setSurround(1)
      self.sndSourceBgsound.setLooping(1)
      self.sndSourceBgsound.empty()
      self.sndSourceBgsound.queue('hs_loop')
      self.sndSourceBgsound.play()

      self.sndSourceMessages.empty()
      self.sndSourceMessages.queue('HStype')

      if self.saisie!='':
        for ch in self.saisie:
          tosay=None
          if ord(ch) in range(97,97+26): tosay=ch
          elif ord(ch) in range(65,65+26): tosay=chr(ord(ch)+32)

          if tosay != None:
            self.sndSourceMessages.queue(tosay)
      
      self.sndSourceMessages.source_callback = self.cbVoiceTitle
      self.sndSourceMessages.play()

    else:
      self.status = 2

####    self.BVOLPLUS=myButton(self.back,self.Resource('_VolPlus'),'std')
####    self.BVOLPLUS.pyattach(self.__class__.cbIncVolume,self)
####    self.BVOLMOINS=myButton(self.back,self.Resource('_VolMoins'),'std')
####    self.BVOLMOINS.pyattach(self.__class__.cbDecVolume,self)

      self.displayScores()

      self.sndSourceMessages.empty()
      self.sndSourceMessages.queue('HSL')
      self.sndSourceMessages.source_callback = self.cbVoiceTitle
      self.sndSourceMessages.play()


  def encode (self, word):
    return unicode(word,'latin-1')
    

  def addWordToSource (self, word):
    for letter in word:
      self.sndSourceMessages.queue(letter)


  def cbGrabFocusMenu (self, name):
    canplay = 0
    self.sndSourceMessages.empty()
    self.sndSourceMessages.source_callback = None

    if self.ticksound != None:
      self.sndSourceMessages.queue(self.ticksound)
      canplay = 1

    num = int(name[2:])
    if num < len(self.liste.hsliste):
      self.sndSourceMessages.queue("HSpos%02d"%(num+1))
      self.addWordToSource(self.liste.hsliste[num].scoreName())
      phrase = self.getSentenceToSay(self.liste.hsliste[num].scoreValue())
      if phrase != []:
        for mot in phrase: self.sndSourceMessages.queue(mot)
      canplay = 1

    if canplay == 1:
      self.sndSourceMessages.source_callback = None
      self.sndSourceMessages.play()


  def cbVoiceTitle (self, name):
    self.sndSourceMessages.source_callback = None
    if self.status == 1:
      self.set_focus(self.BPanneau.__id__)
      self.status = 3
    elif self.status == 2:
      self.set_focus(self.findFocusIndex(self.Order[0]))


  def displayScores (self):
    for i in range(self.liste.nbscores):
      self.addMenuItem('HS'+`i`,'init',"Yes")
      if i < len(self.liste.hsliste):
        self.menuButton('HS'+`i`).text = `i+1`+'. '+self.liste.hsliste[i].createDisplay()

    self.setTickSound('menutick')
    self.setTopBottomSounds('menutopdown')

    self.BEsc = Widget(self, '_Esc', 'init')
    self.BEsc.hidden = True
    self.BEsc.validate_callback = self.cbEsc


  def launchCallback (self, name):
    self.cbDispScore(self.selectedItem,None,None)


  def cbValide (self,name, type, key):
    if self.status == 3:
      self.status = 4
      if self.saisie != '':
        self.saisie = self.saisie.encode('latin-1')
        self.gameInfo.playerName = self.saisie
      else:
        self.saisie = 'Unknown'

      del self.BSubTitle
      del self.BPanneau
      
      pos = self.liste.insertScore(
        self.gameInfo.score,
        self.saisie,
        self.gameInfo.nbMonstersDefeated,
        self.gameInfo.nbLevelsCompleted)

      self.liste.saveHSFile(SCORE_FILE)

      self.displayScores()
      self.set_focus(self.findFocusIndex(self.Order[0]))
      self.status = 2

      self.sndSourceMessages.empty()
      if pos==0:
        self.sndSourceMessages.queue('HSintro1')
      else:
        self.sndSourceMessages.queue('HSintro2')
  
      self.sndSourceMessages.queue("HSpos%02d"%(pos+1))
  
      self.sndSourceMessages.source_callback = None
      self.sndSourceMessages.play()        


  def cbDelete (self, name, type, key):
    if len(self.saisie) > 0:
      self.sndSourceMessages.empty()
      self.sndSourceMessages.queue('deleteKey')
      self.sndSourceMessages.play()
      self.saisie = self.saisie[:len(self.saisie)-1]
      self.BPanneau.text = self.saisie
      self.BPanneau.alt = self.saisie
    else:
      self.sndSourceMessages.empty()
      self.sndSourceMessages.queue('emptyKey')
      self.sndSourceMessages.play()
    return 0


  def keysCallback (self, name, type, key):
    if key == KeyCode.CARET:
      self.caretFlag = 1
      self.umlFlag = 0
      
    elif key == KeyCode.WORLD_8:
      self.caretFlag = 0
      self.umlFlag = 1
      
    else:
      char = chr(key)
      
      if self.caretFlag == 1:
        if char == 'a':
          char = ''
        elif char == 'e':
          char = ''
        elif char == 'i':
          char = ''
        elif char == 'o':
          char = ''
        elif char == 'u':
          char = ''
          
      elif self.umlFlag == 1:
        if char == 'e':
          char = ''
        elif char == 'i':
          char = ''
        elif char == 'u':
          char = ''
            
      self.caretFlag = 0
      self.umlFlag = 0

      letter = self.encode(char)

      self.sndSourceMessages.empty()
      self.sndSourceMessages.queue(letter)
      self.sndSourceMessages.play()

      self.saisie += letter
      self.BPanneau.text = self.saisie
      self.BPanneau.alt = self.saisie


  def cbDispScore (self,name, type, key):
    num = int(name[2:])
    
    if num < len(self.liste.hsliste):
      self.sndSourceMessages.empty()
      phrase=self.getSentenceToSay(self.liste.hsliste[num].scoreValue())
      if phrase!=[]:
        for mot in phrase: self.sndSourceMessages.queue(mot)

      self.sndSourceMessages.queue('statsGame')

      self.sndSourceMessages.queue('gs_monsterdefeat')
      phrase=self.getSentenceToSay(self.liste.hsliste[num].monstersValue())
      if phrase!=[]:
        for mot in phrase: self.sndSourceMessages.queue(mot)

      self.sndSourceMessages.queue('gs_levelscomplete')
      phrase=self.getSentenceToSay(self.liste.hsliste[num].levelsValue())
      if phrase!=[]:
        for mot in phrase: self.sndSourceMessages.queue(mot)

      self.sndSourceMessages.source_callback = None
      self.sndSourceMessages.play()

    self._menustatus = 1


  def getSentenceToSay (self, num):
    phrase = self.sayNumbersEngine.tospeech1e6(num,self.lang)
    if phrase!='overflow': return map(lambda c:c[1],phrase)
    return []


  def cbEsc (self,name, type, key):
    self.sndSourceMessages.empty()
    self.sndSourceMessages.queue('menuback')
    self.sndSourceMessages.source_callback=self.cbBackToMenu
    self.sndSourceMessages.play()        


  def cbBackToMenu (self, name):
    self.next=MenuSc
    self.nextargs=[self.gameInfo]



# -- ----------------------------------------------------------------
#    Help Scene
# -- ----------------------------------------------------------------

class HelpSc (myMenu):

  def __init__ (self, parent, gameInfo):

    myMenu.__init__(self,parent,'help','menu01')
    self.gameInfo = gameInfo

    self.tree = helpTree()
    self.subtitle = None
    self.maintext = None
    self.parcours = ['main']

    self.BTitle = Widget(self,'_TitleHelp','init')
    self.focus = self.BTitle.__id__
    self.setTickSound('menutick')
    self.setTopBottomSounds('menutopdown')
    
    self.zoom_widget = Widget(self, 'zoom', 'init')
    self.zoom_widget.hidden = True
    self.zoom_widget.validate_callback = self.zoom_callback
    
    self.exit = Widget(self, '_Exit','std')
    self.exit.hidden = True
    self.exit.validate_callback = self.cbEsc

    #self.sndSourceMessages.empty()
    #self.sndSourceMessages.queue('helpesc')
    #self.sndSourceMessages.source_callback = self.displayCallback
    #self.sndSourceMessages.play()
    self.firstTime = True
    self.displayPage('main')


  def displayCallback (self, name):
    self.displayPage('main')


  def cbEsc (self, name, type, key):
    parent = self.tree.getParent()
    self.sndSourceMessages.empty()
    self.sndSourceMessages.queue('menuback')
    
    if parent == '':
      self.sndSourceMessages.source_callback=self.cbBackToMenu
    else:
      self.sndSourceMessages.source_callback=self.cbBackToParent

    self.sndSourceMessages.play()        


  def cbBackToParent (self, name): 
    parent = self.tree.goToParent()
    self.displayPage(parent)


  def cbBackToMenu (self, name):
    del self.sndSourceMessages
    self.next = MenuSc
    self.nextargs = [self.gameInfo]


  def displayPage (self, pageident):
    self.focus = self.BTitle.__id__
    self.removeAllMenuItems()

    if self.subtitle != None:
      del self.subtitle
      self.subtitle = None
    if self.maintext != None:
      del self.maintext
      self.maintext = None

    self.links = {}
    self.sndSourceMessages.empty()
    
    self.state = self.tree.getType()

    if self.state == 'menu01':
      self.mainSndList = {}
      for it in self.tree.getFils():
        self.mainSndList[it['link']] = it['sound']

    if self.state == 'menu02':
      self.setLaunchSound(None)
    else:
      self.setLaunchSound('menuconfirm')

    if self.state in ['menu01', 'menu02', 'menu03']:

      for it in self.tree.getFils():
        if it['name'] != 'HelpM1_4':
          self.addMenuItem(it['name'], 'init', cb="Yes", voiceFile=it['sound'])
        else:
          self.addMenuItem(it['name'], 'init', cb="Yes", voiceFile=it['sound'], sndFile='menuback')
        self.menuButton(it['name']).state = self.tree.getCurrent()
        self.links[it['name']] = it['link']

    elif self.state == 'content01':

      self.subtitle = Widget(self, 'HelpC1_t', 'init')
      self.subtitle.state = self.tree.getCurrent()

      self.maintext = Widget(self, 'HelpC1_c', 'init')
      self.maintext.state = self.tree.getCurrent()

    elif self.state == 'content02':
              
      self.maintext = Widget(self, 'HelpC2_c', 'init')
      self.maintext.state = self.tree.getCurrent()

    if (self.state in ['content01', 'content02']) and (self.tree.getSound() != None):
      self.sndSourceMessages.queue(self.tree.getSound())
      self.sndSourceMessages.source_callback = self.cbEsc
      self.sndSourceMessages.play()

    if self.state in ['menu02', 'menu03']:
      num = self.state[-1]
      self.subtitle = Widget(self, 'HelpM'+num+'_t', 'init')
      self.subtitle.state = self.tree.getCurrent()

    if self.state in ['menu03']:
      self.setLaunchSound(None)

    self.initFocus()
    self._menustatus = 1


  def initFocus (self):
    if self.state in ['menu02', 'menu03']:
      self.sndSourceMessages.empty()
      self.sndSourceMessages.queue(self.mainSndList[self.tree.getCurrent()])
      self.sndSourceMessages.source_callback = self.initFocus2
      self.sndSourceMessages.play()        
    elif self.state == 'menu01':
      self.sndSourceMessages.empty()
      self.sndSourceMessages.queue('mh0A')
      if self.firstTime == True:
        self.sndSourceMessages.queue('helpesc')
        self.firstTime = False
      self.sndSourceMessages.source_callback = self.initFocus2
      self.sndSourceMessages.play()        
    else:
      self.initFocus2(None)

    
  def initFocus2 (self, name):
    self.sndSourceMessages.source_callback = None
    if self.state == 'menu01':
      self.set_focus(self.findFocusIndex('HelpM1_0'))
    elif self.state == 'menu02':
      self.set_focus(self.findFocusIndex('HelpM2_0'))
    elif self.state == 'menu03':
      self.set_focus(self.findFocusIndex('HelpM3_0'))
    elif self.state == 'content01':
      self.focus = self.maintext.__id__

      
  def launchCallback (self, name):
    self.cbMenuItem(self.selectedItem,None,None)


  def cbMenuItem (self, name, type, key):
    self._menustatus = 1
    link = self.links[name]
    
    if self.tree.getType() == 'menu03':

      if link != '':
        tree = self.tree.getTree()
        self.sndSourceMessages.empty()
        self.sndSourceMessages.queue(tree[link]['sound'])
        self.sndSourceMessages.source_callback = self.cbMenuItem2
        self.sndSourceMessages.play()

      else:
        return self.cbMenuItem2(name)

    else:
    
      if (name == 'HelpM1_4'):
        self.cbBackToMenu(None)
      else:
        self.tree.goToFils(link)
        self.displayPage(link)

    return 0


  def cbMenuItem2 (self, name):
    self._menustatus = 1
    return 0

      

# -- ----------------------------------------------------------------
#    Mudsplat Game Arguments
# -- ----------------------------------------------------------------

class mudsplatArgs:

  def __init__(self):
    self.levels=mLevels.levels
    self.levelliste=mLevels.levelliste1
    self.remainingtime=-1
    self.show=0
    self.playerName=''

    self.setDefaultValues()

  def setDefaultValues(self):
    self.levelID=0
    self.score=0
    self.lives=3
    self.nbMonstersDefeated=0
    self.nbLevelliste=len(self.levelliste)
    self.nbLevelsCompleted=0
    self.nbLevelObjects=0
    self.newlevel=0
    self.autoSaveName=('RESCUE FILE','RESCUE')

  def isLevelInListe(self,num):
    return num<self.nbLevelliste

  def setLevelListe(self,liste):
    self.levelliste=liste
    self.nbLevelliste=len(self.levelliste)
    
  #-- --------------------------------------------------
  def getLevelName(self):
    return self.levelliste[self.levelID]

  def getLevel(self,name=None):
    if name==None:
      return self.levels[self.levelliste[self.levelID]]
    else:
      return self.levels[name]

  #-- --------------------------------------------------
  def getRemainingTime(self):
    if self.remainingtime!=-1: return self.remainingtime*1000
    else: return None
  def setRemainingTime(self,rt): self.remainingtime=rt

  #-- --------------------------------------------------
  def getLevelID(self): return self.levelID
  def setLevelID(self,value):
    if not self.isLevelInListe(value):
      self.levelliste.append(value)
      self.levelID=self.levelliste.index(value)
    else:
      self.levelID=value
      
  def getScore(self): return self.score
  def setScore(self,value): self.score=value
      
  def getLives(self): return self.lives
  def setLives(self,value): self.lives=value
      
  def getNbMonstersDefeated(self): return self.nbMonstersDefeated
  def setNbMonstersDefeated(self,value): self.nbMonstersDefeated=value
      
  def getNbLevelsCompleted(self): return self.nbLevelsCompleted
  def setNbLevelsCompleted(self,value): self.nbLevelsCompleted=value
      
  def getNbLevelObjects(self): return self.nbLevelObjects
  def setNbLevelObjects(self,value): self.nbLevelObjects=value
      
  def getNewlevel(self): return self.newlevel
  def setNewlevel(self,value): self.newlevel=value

  #-- --------------------------------------------------
  def autoSaveGame (self):
    self.saveGame(self.autoSaveName)

  def copySaveGame (self, name):
    copy(LOCAL_FOLDER+self.autoSaveName[1],LOCAL_FOLDER+name[1])
      
  def saveGame (self,user):
    f=open(LOCAL_FOLDER+user[1],"w")
    f.write("# MudSplat "+versionNb+"\n")
    f.write("# USER FILE: "+user[0].encode('latin-1')+"\n")
    f.write("# DO NOT EDIT: GENERATED AUTOMATICALLY\n")

    f.write('level'+'|'+`self.levelID`+'\n')
    f.write('score'+'|'+`self.score`+'\n')
    f.write('lives'+'|'+`self.lives`+'\n')
    f.write('monsterdefeated'+'|'+`self.nbMonstersDefeated`+'\n')
    f.write('levelscompleted'+'|'+`self.nbLevelsCompleted`+'\n')
    f.write('levelobjects'+'|'+`self.nbLevelObjects`+'\n')

    f.close()

  def loadGame(self,filename):
    f=open(LOCAL_FOLDER+filename,"r")
    line=f.readline()
    savedvalues={}
    while line:
      if line[0]!='#':
        u=split(line.rstrip(),'|')
        savedvalues[u[0]]=eval(u[1])
      line=f.readline()
    f.close()

    if savedvalues.has_key('level'):
      self.levelID=savedvalues['level']

    if savedvalues.has_key('lives'):
      self.lives=savedvalues['lives']

    if savedvalues.has_key('score'):
      self.score=savedvalues['score']

    if savedvalues.has_key('monsterdefeated'):
      self.nbMonstersDefeated=savedvalues['monsterdefeated']
      
    if savedvalues.has_key('levelscompleted'):
      self.nbLevelsCompleted=savedvalues['levelscompleted']
      
    if savedvalues.has_key('levelobjects'):
      self.nbLevelObjects=savedvalues['levelobjects']

    self.newlevel=0

  #-- --------------------------------------------------
  def saveRescueFile(self):
    self.saveGame(('RESCUE FILE','RESCUE'))
  
  def removeRescueFile(self):
    if exists(RESCUE_FILE): remove(RESCUE_FILE)

  #-- --------------------------------------------------
  def getScene(self,which):
    if which=='menu': return MenuSc
    elif which=='highscore': return HighScoreSc
    elif which=='saveload': return SaveLoadSc
    else: raise BSError, 'Unknown scene'


# -- ----------------------------------------------------------------
#    Start of the program
# -- ----------------------------------------------------------------

if __name__ == '__main__':

  gameInfo=mudsplatArgs()

  if devMode == 0 and sys.platform[:3] == 'win':
    thescene = Intro
    lang = 'en'

  else:

    if len(sys.argv) == 1:
      lang = 'fr'
    
    elif len(sys.argv) == 2:
      lang = sys.argv[1] 
    
    elif len(sys.argv) == 3:
      lang = sys.argv[1]

      try:
        gameInfo.setRemainingTime(int(sys.argv[2]))
        gameInfo.setLevelListe(mLevels.levelliste2)
      except ValueError:
        pass
      
    else:
      raise BSError, "Usage: mudsplat.py [lang] [time]"

    lang = 'en'
    gameInfo.show = 1
    gameInfo.setLevelListe(mLevels.levelliste2)
    #gameInfo.setNbLevelObjects(3)

    gameInfo.score = 330
    #gameInfo.lives = 1

    #gameInfo.nbMonstersDefeated = 12
    #gameInfo.nbLevelsCompleted = 5

    #thescene = Intro
    #thescene = MenuSc
    #thescene = MainSc
    #thescene = HighScoreSc
    #thescene = SaveLoadSc
    #thescene = HelpSc
    thescene  = CreditsSc
    
  jeu = Game(stylesheet = "data/mudsplat.xml",
             scene = thescene,
             sceneargs=[gameInfo],
             lang=lang)

  jeu.setAutorepeat(10,250)
  jeu.run()
  del jeu
  print "Fin normale"

# -- ----------------------------------------------------------------
